*-------------------------------------------------------------------------------
*						Appendix IV Fig 2
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix IV Fig 2", replace 
set more off     


**---------------------------------------
* Step1: Generate Data
**---------------------------------------
clear
clear all

//empty file for processed data
clear
set obs 0
save plotdata,replace emptyok


foreach j in "2000" "2010" "2015"{
use "`j'census_consistent.dta",clear
//no farmers
preserve
drop if substr(occ_`j',1,1)=="5"
gen id_new=_n
keep id_new index*
gen year="`j'noa"
append using plotdata
save plotdata,replace
restore
//include farmers
preserve
gen id_new=_n
keep id_new index*
gen year="`j'"
append using plotdata
save plotdata,replace
restore
}


**---------------------------------------
* Step2: Plot
**---------------------------------------
use plotdata,clear

// cognitive vs physical
label var index3_cognitive "认知能力"
label var index4_physical "体力能力"

// routine manual vs routine cognitive
label var index5_routinemanual "重复性体力"
label var index6_routinecognitive "重复性认知"

// competiton vs interaction
label var index1_competition "竞争要求"
label var index2_interact "协同要求"

rename *_* .*

/*
//Plot for all occupations
foreach var of varlist competition-routinecognitive{
preserve
sort year `var'
by year:cumul `var', gen(cum_`var')
gen temp_`var'=cum_`var'*100
drop cum_`var'
rename temp_`var' cum_`var'
	twoway (line cum_`var' `var' if year=="2000",sort lcolor(black%20) lp(shortdash)) ///
	(line cum_`var' `var' if year=="2010",sort lcolor(black%60) lp(dash)) ///
	(line cum_`var' `var' if year=="2015",sort lcolor(black) lp(solid)), ///
legend(label(1 "2000") label(2 "2010") label(3 "2015") ring(0) position(5)) scheme(plotplain) ///
ytitle("累计就业占比（%）") xline(0,lcolor(red) lp(dash_dot)) xlabel(,nogrid) ylabel(,nogrid)
graph save "$Out_lab\Fig3_`var'",replace
graph export "$Out_lab\Fig3_`var'.png",replace
restore
}

*/

//Plot for occupations without farmers
foreach var of varlist competition-routinecognitive{
preserve
sort year `var'
by year:cumul `var', gen(cum_`var')
gen temp_`var'=cum_`var'*100
drop cum_`var'
rename temp_`var' cum_`var'
	twoway (line cum_`var' `var' if year=="2000noa",sort lcolor(black%20) lp(shortdash)) ///
	(line cum_`var' `var' if year=="2010noa",sort lcolor(black%60) lp(dash)) ///
	(line cum_`var' `var' if year=="2015noa",sort lcolor(black) lp(solid)), ///
legend(label(1 "2000") label(2 "2010") label(3 "2015") ring(0) position(5)) scheme(plotplain) ///
ytitle("累计就业占比（%）") xline(0,lcolor(red) lp(dash_dot)) xlabel(,nogrid) ylabel(,nogrid)
graph save "$Out_lab\appIV_Fig2_`var'",replace
graph export "$Out_lab\appIV_Fig2_`var'.png",replace
restore
}

*Delet Plotdata
erase plotdata.dta

log close




